/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_H_
#define PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_H_

// Core
#include <IgnitionStdint.h>
#include <Function.h>
#include <UniquePtr.h>

// Renderer
#include "RendererConfig.h"
#include "api/rendererTypes.h"

namespace ignition
{
namespace renderer
{
namespace video
{

typedef void* VideoFrameHandle;

struct PLUGINRENDERER_API VideoFrame
{
	typedef core::function<void(VideoFrameHandle)> ReleaseFrameHandleFunc;

	VideoFrameHandle handle;
	uint8_t* data;
	uint16_t width;
	uint16_t height;
	uint16_t pitch;
	uint32_t sampleAspectRatioWidth;
	uint32_t sampleAspectRatioHeight;

	// Some platforms provide a larger texture buffer than the dimensions
	// of the video. In this case we need to account for the width difference
	// when setting the UV values for the shader, and the height difference
	// when calculating the chroma data offset in YUV images.	
	uint16_t actualWidthInPixels;
	uint16_t actualHeightInPixels;

	ColorFormat colorFormat;
	ColorType colorType;
	
	VideoFrame(ReleaseFrameHandleFunc releaseFunc);
	VideoFrame(const VideoFrame& videoFrame) = delete;
	VideoFrame(VideoFrame&& videoFrame);
	VideoFrame& operator=(const VideoFrame& videoFrame) = delete;
	VideoFrame& operator=(VideoFrame&& videoFrame);
	bool operator==(const VideoFrame& videoFrame);
	void release();

private:

	void _clearMembers();
	void _emptyReleaseFunction(VideoFrameHandle);

	ReleaseFrameHandleFunc _releaseFunc;
};

typedef core::memory::UniquePtr<VideoFrame> VideoFramePtr;

} // namespace video
} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_H_

