/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_VIDEO_IVIDEO_FRAME_RECEIVER_H_
#define PLUGIN_RENDERER_VIDEO_IVIDEO_FRAME_RECEIVER_H_

// Core
#include <IgnitionStdint.h>
#include <SmartPointers.h>
#include <utils/UUID.h>

// Renderer
#include "RendererConfig.h"
#include "video/VideoFrame.h"

namespace ignition
{
namespace renderer
{
namespace video
{

typedef void* VideoFrameHandle;

class PLUGINRENDERER_API IVideoFrameReceiver : public core::UUID
{
public:
	virtual ~IVideoFrameReceiver() {}
	virtual void videoFrameReady(VideoFrame& videoFrame) = 0;
};

typedef core::memory::SharedPtr<IVideoFrameReceiver> VideoFrameReceiverPtr;

} // namespace video
} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_VIDEO_IVIDEO_FRAME_RECEIVER_H_

