/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_EVENTS_SPLASH_SCREEN_EVENT_H_
#define PLUGIN_RENDERER_EVENTS_SPLASH_SCREEN_EVENT_H_

// core
#include <event/events/Event.h>
#include <event/EventHandler.h>

namespace ignition
{
namespace renderer
{

class SplashScreenEvent : public core::event::Event
{
	REGISTER_EVENT(SplashScreenEvent);

public:
	static const core::event::EventName DISMISS_SPLASH_SCREEN;
	static const core::event::EventName SHOW_SPLASH_SCREEN;

	static SplashScreenEvent* create(
			const core::event::EventName name,
			const core::UUID& sender,
			unsigned int fadeDurationMs);

	static SplashScreenEvent* clone(const SplashScreenEvent& rhs);
	static SplashScreenEvent& cast(core::event::Event& event);

	SplashScreenEvent(const SplashScreenEvent& other);
	SplashScreenEvent& operator=(const SplashScreenEvent& rhs);

	unsigned int getFadeDurationMs() const;

	void accept(core::event::EventHandler* const handler, core::event::Context& ctx);

protected:
	SplashScreenEvent(
			const core::event::EventName name,
			const core::UUID& sender,
			unsigned int fadeDurationMs);

	unsigned int _fadeDurationMs;
};

} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_EVENTS_SPLASH_SCREEN_EVENT_H_
