/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_API_RENDERER_TYPES_H_
#define PLUGIN_RENDERER_API_RENDERER_TYPES_H_

namespace ignition
{
namespace renderer
{

#ifndef INVALID_UNIFORM_LOCATION
#define INVALID_UNIFORM_LOCATION -1
#endif

#ifndef INVALID_ATTRIBUTE_LOCATION
#define INVALID_ATTRIBUTE_LOCATION -1
#endif

enum DepthTest
{
	DEPTH_TEST_ALWAYS,
	DEPTH_TEST_EQUAL,
	DEPTH_TEST_NOT_EQUAL,
	DEPTH_TEST_LESS,
	DEPTH_TEST_LESS_EQUAL,
	DEPTH_TEST_GREATER,
	DEPTH_TEST_GREATER_EQUAL,
	INVALID_DEPTH_TEST,
	NUM_DEPTH_TEST_MODES = INVALID_DEPTH_TEST
};

enum StencilFunc
{
	STENCIL_FUNC_NEVER,
	STENCIL_FUNC_ALWAYS,
	STENCIL_FUNC_EQUAL,
	STENCIL_FUNC_NOT_EQUAL,
	STENCIL_FUNC_LESS,
	STENCIL_FUNC_LESS_EQUAL,
	STENCIL_FUNC_GREATER,
	STENCIL_FUNC_GREATER_EQUAL,
	INVALID_STENCIL_FUNC,
	NUM_STENCIL_FUNCS = INVALID_STENCIL_FUNC
};

enum StencilOp
{
	STENCIL_OP_KEEP,
	STENCIL_OP_ZERO,
	STENCIL_OP_REPLACE,
	STENCIL_OP_INCR,
	STENCIL_OP_INCR_WRAP,
	STENCIL_OP_DECR,
	STENCIL_OP_DECR_WRAP,
	STENCIL_OP_INVERT,
	INVALID_STENCIL_OP,
	NUM_STENCIL_OPS = INVALID_STENCIL_OP
};

enum BlendMode
{
	BLEND_MODE_NORMAL,
	BLEND_MODE_OPAQUE,
	INVALID_BLEND_MODE,
	NUM_BLEND_MODES = INVALID_BLEND_MODE,
	DEFAULT_BLEND_MODE = BLEND_MODE_NORMAL
};

enum BlendFunc
{
	BLEND_FUNC_ZERO,
	BLEND_FUNC_ONE,
	BLEND_FUNC_SRC_COLOR,
	BLEND_FUNC_ONE_MINUS_SRC_COLOR,
	BLEND_FUNC_DST_COLOR,
	BLEND_FUNC_ONE_MINUS_DST_COLOR,
	BLEND_FUNC_SRC_ALPHA,
	BLEND_FUNC_ONE_MINUS_SRC_ALPHA,
	BLEND_FUNC_DST_ALPHA,
	BLEND_FUNC_ONE_MINUS_DST_ALPHA,
	BLEND_FUNC_CONSTANT_COLOR,
	BLEND_FUNC_ONE_MINUS_CONSTANT_COLOR,
	BLEND_FUNC_CONSTANT_ALPHA,
	BLEND_FUNC_ONE_MINUS_CONSTANT_ALPHA,
	BLEND_FUNC_SRC_ALPHA_SATURATE,
	INVALID_BLEND_FUNC,
	NUM_BLEND_FUNCS = INVALID_BLEND_FUNC
};

enum TextureType
{
	TEXTURE_TYPE_2D = 0,
	TEXTURE_TYPE_CUBE_MAP,
	TEXTURE_TYPE_EXTERNAL,
	NUM_TEXTURE_TYPES
};

enum TextureUnit
{
	TEXTURE_UNIT_0 = 0,
	TEXTURE_UNIT_1,
	TEXTURE_UNIT_2,
	TEXTURE_UNIT_3,
	TEXTURE_UNIT_4,
	TEXTURE_UNIT_5,
	TEXTURE_UNIT_6,
	TEXTURE_UNIT_7,
	TEXTURE_UNIT_INVALID,
	TEXTURE_UNIT_AUTOMATIC = TEXTURE_UNIT_INVALID,
	NUM_TEXTURE_UNITS = TEXTURE_UNIT_AUTOMATIC
};

enum TextureCubeFace
{
	TEXTURE_CUBE_FACE_POSITIVE_X = 0,
	TEXTURE_CUBE_FACE_NEGATIVE_X,
	TEXTURE_CUBE_FACE_POSITIVE_Y,
	TEXTURE_CUBE_FACE_NEGATIVE_Y,
	TEXTURE_CUBE_FACE_POSITIVE_Z,
	TEXTURE_CUBE_FACE_NEGATIVE_Z,
	TEXTURE_CUBE_FACE_INVALID,
	NUM_TEXTURE_CUBE_FACES = TEXTURE_CUBE_FACE_INVALID
};

enum AttributeType
{
	ATTRIBUTE_TYPE_POSITION = 0,
	ATTRIBUTE_TYPE_NORMAL,
	ATTRIBUTE_TYPE_TEXCOORD,
	ATTRIBUTE_TYPE_TEXCOORD1,
	ATTRIBUTE_TYPE_COLOR,
	ATTRIBUTE_TYPE_INVALID,
	NUM_ATTRIBUTE_TYPES = ATTRIBUTE_TYPE_INVALID
};

enum ColorFormat
{
	COLOR_FORMAT_R = 0,
	COLOR_FORMAT_RG,
	COLOR_FORMAT_RGB,
	COLOR_FORMAT_RGBA,
	COLOR_FORMAT_BGRA,
	COLOR_FORMAT_ETC1,
	COLOR_FORMAT_RGB_S3TC_DXT1,
	COLOR_FORMAT_RGBA_S3TC_DXT1,
	COLOR_FORMAT_RGBA_S3TC_DXT3,
	COLOR_FORMAT_RGBA_S3TC_DXT5,
	COLOR_FORMAT_EGL_IMAGE,
	COLOR_FORMAT_YUV422,
	COLOR_FORMAT_INVALID,
	NUM_COLOR_FORMATS = COLOR_FORMAT_INVALID
};

enum ColorType
{
	COLOR_TYPE_UNSIGNED_BYTE,
	COLOR_TYPE_UNSIGNED_SHORT_5_6_5,
	COLOR_TYPE_UNSIGNED_SHORT_4_4_4_4,
	COLOR_TYPE_UNSIGNED_SHORT_5_5_5_1,
	COLOR_TYPE_FLOAT,
	COLOR_TYPE_INVALID,
	NUM_COLOR_TYPES = COLOR_TYPE_INVALID
};

enum FrameBufferAttachment
{
	FRAME_BUFFER_ATTACHMENT_COLOR = 0,
	FRAME_BUFFER_ATTACHMENT_DEPTH,
	FRAME_BUFFER_ATTACHMENT_PACKED_DEPTH_STENCIL = FRAME_BUFFER_ATTACHMENT_DEPTH,
	FRAME_BUFFER_ATTACHMENT_STENCIL,
	FRAME_BUFFER_ATTACHMENT_INVALID,
	NUM_FRAME_BUFFER_ATTACHMENT_POINTS = FRAME_BUFFER_ATTACHMENT_INVALID
};

enum PrimitiveType
{
	PRIMITIVE_TYPE_POINTS,
	PRIMITIVE_TYPE_LINE_STRIP,
	PRIMITIVE_TYPE_LINE_LOOP,
	PRIMITIVE_TYPE_LINES,
	PRIMITIVE_TYPE_TRIANGLE_STRIP,
	PRIMITIVE_TYPE_TRIANGLE_FAN,
	PRIMITIVE_TYPE_TRIANGLES,
	PRIMITIVE_TYPE_INVALID,
	NUM_PRIMITIVE_TYPES = PRIMITIVE_TYPE_INVALID
};

enum ShaderType
{
	SHADER_TYPE_VERTEX = 0,
	SHADER_TYPE_FRAGMENT,
	SHADER_TYPE_INVALID,
	NUM_SHADER_TYPES = SHADER_TYPE_INVALID
};

enum ShaderDataType
{
	SHADER_DATATYPE_BYTE,
	SHADER_DATATYPE_UNSIGNED_BYTE,
	SHADER_DATATYPE_SHORT,
	SHADER_DATATYPE_UNSIGNED_SHORT,
	SHADER_DATATYPE_FIXED,
	SHADER_DATATYPE_FLOAT,
	SHADER_DATATYPE_INVALID,
	NUM_SHADER_DATATYPES = SHADER_DATATYPE_INVALID
};

enum ShaderBasicType
{
	SHADER_BASICTYPE_BOOL,
	SHADER_BASICTYPE_INT,
	SHADER_BASICTYPE_FLOAT,
	SHADER_BASICTYPE_VEC2,
	SHADER_BASICTYPE_VEC3,
	SHADER_BASICTYPE_VEC4,
	SHADER_BASICTYPE_BVEC2,
	SHADER_BASICTYPE_BVEC3,
	SHADER_BASICTYPE_BVEC4,
	SHADER_BASICTYPE_IVEC2,
	SHADER_BASICTYPE_IVEC3,
	SHADER_BASICTYPE_IVEC4,
	SHADER_BASICTYPE_MAT2,
	SHADER_BASICTYPE_MAT3,
	SHADER_BASICTYPE_MAT4,
	SHADER_BASICTYPE_SAMPLER2D,
	SHADER_BASICTYPE_SAMPLER_CUBE,
	SHADER_BASICTYPE_SAMPLER_EXTERNAL_OES,
	SHADER_BASICTYPE_INVALID,
	NUM_SHADER_BASICTYPES = SHADER_BASICTYPE_INVALID,
};

enum TextureMinFilter
{
	TEXTURE_MIN_FILTER_NEAREST,
	TEXTURE_MIN_FILTER_LINEAR,
	TEXTURE_MIN_FILTER_NEAREST_MIPMAP_NEAREST,
	TEXTURE_MIN_FILTER_LINEAR_MIPMAP_NEAREST,
	TEXTURE_MIN_FILTER_NEAREST_MIPMAP_LINEAR,
	TEXTURE_MIN_FILTER_LINEAR_MIPMAP_LINEAR,
	TEXTURE_MIN_FILTER_INVALID,
	NUM_TEXTURE_MIN_FILTERS = TEXTURE_MIN_FILTER_INVALID
};

enum TextureMagFilter
{
	TEXTURE_MAG_FILTER_NEAREST,
	TEXTURE_MAG_FILTER_LINEAR,
	TEXTURE_MAG_FILTER_INVALID,
	NUM_TEXTURE_MAG_FILTERS = TEXTURE_MAG_FILTER_INVALID
};

enum TextureWrapMode
{
	TEXTURE_WRAP_MODE_CLAMP_TO_EDGE,
	TEXTURE_WRAP_MODE_REPEAT,
	TEXTURE_WRAP_MODE_MIRRORED_REPEAT,
	TEXTURE_WRAP_MODE_INVALID,
	NUM_TEXTURE_WRAP_MODES = TEXTURE_WRAP_MODE_INVALID
};

enum RendererExtension
{
	RENDERER_EXTENSION_COMPRESSED_ETC1_RGB8,
	RENDERER_EXTENSION_COMPRESSED_DXT1,
	RENDERER_EXTENSION_COMPRESSED_S3TC,
	RENDERER_EXTENSION_DISCARD_FRAMEBUFFER,
	RENDERER_EXTENSION_PACKED_DEPTH_STENCIL,
	RENDERER_EXTENSION_NON_POWER_OF_TWO_TEXTURES,
	RENDERER_EXTENSION_EGL_IMAGE_EXTERNAL,
	INVALID_RENDERER_EXTENSION,
	NUM_RENDERER_EXTENSIONS = INVALID_RENDERER_EXTENSION
};

enum PrecisionModifier
{
	PRECISION_MODIFIER_DEFAULT,
	PRECISION_MODIFIER_LOWP,
	PRECISION_MODIFIER_MEDIUMP,
	PRECISION_MODIFIER_HIGHP,
	NUM_PRECISION_MODIFIERS
};

} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_API_RENDERER_TYPES_H_
