/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_I_RENDERER_H_
#define PLUGIN_RENDERER_I_RENDERER_H_

// Renderer
#include "video/VideoFrameBroadcaster.h"

// Core
#include <plugin/IPlugin.h>
#include <RendererConfig.h>
#include <tasks/RenderTask.h>

#include <glm/glm.hpp>
#include <glm/gtc/type_precision.hpp>

namespace ignition
{
namespace renderer
{

typedef core::function<void (
		const core::vector<char>&,
		unsigned int,
		unsigned int)> OnScreenShotTakenCallback;

class PLUGINRENDERER_API IRenderer : public core::plugin::IPlugin
{
	REGISTER_PLUGIN_NAME(com.amazon.ignition.framework.renderer);

public:
	typedef std::vector<std::string> DebugMessageLines;

	IRenderer() {}
	virtual ~IRenderer() {};

	virtual void saveScreenShot(const std::string& filename) = 0;

	virtual void toggleWireframeMode() = 0;

	virtual void getScreenShot(const OnScreenShotTakenCallback& callback) = 0;

	virtual void enableTelemetry(bool enable) = 0;
	
	virtual void renderText(const std::string& text, glm::vec2 position,
			glm::u8vec4 color) = 0;

	virtual void registerVideoFrameBroadcaster(video::VideoFrameBroadcaster& videoFrameBroadcaster) = 0;

	virtual void setDebugMessageLines(const DebugMessageLines& lines) = 0;
};

} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_I_RENDERER_H_
