#version 100

attribute highp   vec3 a_position;
attribute mediump vec2 a_texcoord0;
attribute lowp    vec4 a_color;

uniform highp mat4 u_model_matrix;
uniform highp mat4 u_view_projection_matrix;

varying mediump vec2 v_texcoord;
varying lowp    vec4 v_color;

void main()
{	
	v_texcoord = a_texcoord0;
	v_color = a_color;
	gl_Position = u_view_projection_matrix * u_model_matrix * vec4(a_position, 1.0);
}
