/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_PLAYER_EVENTS_PLAYER_EVENT_H_
#define PLUGIN_PLAYER_EVENTS_PLAYER_EVENT_H_

#include <event/events/Event.h>

namespace ignition
{
namespace player
{

class PlayerEvent : public core::event::Event
{
	REGISTER_EVENT(PlayerEvent);

public:

	static const core::event::EventName PLAY_PAUSE;
	static const core::event::EventName STOP;

	static PlayerEvent* create(const core::event::EventName name, const core::UUID& sender);
	static PlayerEvent* clone(const PlayerEvent& rhs);
	static PlayerEvent& cast(core::event::Event& event);

	virtual ~PlayerEvent();
	PlayerEvent(const PlayerEvent& other);
	PlayerEvent& operator=(const PlayerEvent& rhs);

	virtual void accept(core::event::EventHandler* const handler, core::event::Context& ctx);

	virtual std::string toString();

private:
	PlayerEvent(const core::event::EventName name, const core::UUID& sender);
};

} /* namespace player */
} /* namespace ignition */

#endif /* PLUGIN_PLAYER_EVENTS_PLAYER_EVENT_H_ */
