/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_PLAYER_PLUGIN_PLAYER_H_
#define PLUGIN_PLAYER_PLUGIN_PLAYER_H_

#include "IPlayer.h"

#include "SmartPointers.h"

namespace ignition
{

namespace javascript
{
class IJavaScript;
}

namespace renderer
{
class IRenderer;
}

namespace player
{

namespace sm
{
class HawaiiExtension;
class PluginPlayerBinder;
}

class PlayerPlatform;

class PluginPlayer : public IPlayer
{
public:
	PluginPlayer();
	virtual ~PluginPlayer();
	virtual void satisfyDependencies(
		core::plugin::IPlugin::DependencyMap dependencies);
	virtual void start();
	virtual void tick();
	virtual void stop();

	std::string getAssetPath();
	static std::string getPluginDirName();

	const static std::string ENABLE_RUBY_PROFILER_OPTION_NAME;
	const static std::string AMP_LOG_LEVEL_OPTION_NAME;
	const static std::string MAX_VIDEO_FRAGMENTS_OPTION_NAME;
	const static std::string MAX_AUDIO_FRAGMENTS_OPTION_NAME;
	const static std::string FAST_REWIND_CACHE_DURATION_OPTION_NAME;
	const static std::string RUBY_DEVICE_DESCRIPTION_MESSAGE_TAG;
	const static std::string MEMORY_SIZE_FOR_RUBY_IN_MEGABYTES;

private:
	static void _staticBindingMessageListener(const std::string& message);
	static void _setChipset(const std::string& message);

	void _addSpiderMonkeyBindings();
	void _onPluginJavaScriptLoaded(javascript::IJavaScript* javaScript);

	javascript::IJavaScript* _javascript;
	renderer::IRenderer* _renderer;
	PlayerPlatform* _playerPlatform;

	sm::HawaiiExtension* _hawaiiExtension;
	core::memory::UniquePtr<sm::PluginPlayerBinder> _playerJsBinder;
};

} // namespace player
} // namespace ignition


#endif // PLUGIN_PLAYER_PLUGIN_PLAYER_H_

