/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_PLAYER_TRICKPLAY_PLUGIN_PLAYER_TRICKPLAY_H_
#define PLUGIN_PLAYER_TRICKPLAY_PLUGIN_PLAYER_TRICKPLAY_H_

#include "IPlayerTrickplay.h"

#include <SmartPointers.h>

namespace ignition
{

namespace scene
{
class IScene;
}

namespace javascript
{
class IJavaScript;
}

namespace player
{

namespace trickplay
{

namespace sm
{
class PluginPlayerTrickplayBinder;
}

class BifFileExtension;

class PluginPlayerTrickplay : public IPlayerTrickplay
{
public:
	PluginPlayerTrickplay();
	virtual ~PluginPlayerTrickplay();

	void start();
	void tick();
	void stop();
	void satisfyDependencies(core::plugin::IPlugin::DependencyMap dependencies);

private:
	void _addSpiderMonkeyBindings();
	void _onPluginJavaScriptLoaded(javascript::IJavaScript* javaScript);

	scene::IScene* _scene;
	javascript::IJavaScript* _javascript;
	BifFileExtension*  _bifFileExtension;
	core::memory::UniquePtr<sm::PluginPlayerTrickplayBinder> _playerJsBinder;
};

} // namespace trickplay
} // namespace player
} // namespace ignition


#endif // PLUGIN_PLAYER_TRICKPLAY_PLUGIN_PLAYER_TRICKPLAY_H_

