/* Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_DATA_NULL_FILE_HTTP_RESPONSE_CONSUMER_H_
#define PLUGIN_NETWORK_HTTP_DATA_NULL_FILE_HTTP_RESPONSE_CONSUMER_H_

#include "http/data/IHttpResponseConsumer.h"

namespace ignition
{
namespace network
{
namespace http
{
namespace data
{

class NullHttpResponseConsumer;

class PLUGINNETWORK_API NullHttpResponseConsumer : public IHttpResponseConsumer
{
	DECLARE_BINDABLE_ID(NullHttpResponseConsumer);

public:
	static const crypto::HashedString TYPE;

	NullHttpResponseConsumer();

	~NullHttpResponseConsumer();

	size_t getSize() const override;
	void setSizeHint(size_t size) override;

	void consume(const void* contents, size_t size) override;
	void consume(const IHttpResponseConsumer& consumer) override;

	void initialise() override;
	void finalise() override;

	IStreamPtr getStream() const override;

	const crypto::HashedString& getType() const override;
};

} // namespace data
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_DATA_NULL_FILE_HTTP_RESPONSE_CONSUMER_H_
