/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_HTTP_STATE_H_
#define PLUGIN_NETWORK_HTTP_HTTP_STATE_H_

#include "NetworkConfig.h"
#include <algorithm/Comparators.h>

namespace ignition
{
namespace network
{
namespace http
{

struct PLUGINNETWORK_API HttpState
{
	// BE AWARE.
	// By altering these enum values you may be affecting the behaviour of
	// the Lua and JS bindings. Make sure changes made here are reflected
	// where applicable.
	enum Type
	{
		//! @brief Request has not been started and is in a dormant state
		NOT_STARTED = 0,

		//! @brief Request is has been started and is in an open state
		STARTED = 1,

		//! @brief Headers have been received
		PROGRESS_HEADERS_RECEIVED = 2,

		//! @brief Data body is loading
		PROGRESS_LOADING = 3,

		//! @brief End-to-end request response was a success.
		//! This does not take into account non-positive return status.
		COMPLETE_SUCCESS = 4,

		//! @brief Http request failed and could not complete
		COMPLETE_FAILURE = 5,

		//! @brief Similar to FAILURE but describes that the specific
		//! timeout failure case
		COMPLETE_TIMEOUT = 6,

		//! @brief Request was aborted before completion
		COMPLETE_ABORT = 7
	};

	static bool isComplete(HttpState::Type state);
	static bool isInProgress(HttpState::Type state);
};

} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_HTTP_STATE_H_
