/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_NETWORK_CRYPTO_CERTPATHCONFIGURATION_H_
#define IGNITION_NETWORK_CRYPTO_CERTPATHCONFIGURATION_H_

#include "NetworkConfig.h"
#include <string>
#include <SmartPointers.h>

namespace ignition
{
namespace network
{

class CertConfiguration;

typedef core::memory::SharedPtr<CertConfiguration> CertConfigurationPtr;
typedef core::memory::SharedPtr<const CertConfiguration> CertConfigurationConstPtr;

class PLUGINNETWORK_API CertConfiguration
{
public:
	static CertConfigurationConstPtr get();
	static void set(CertConfigurationPtr config);

	static CertConfigurationPtr create();

	~CertConfiguration();

	bool hasCACert() const;
	bool hasClientCert() const;
	bool hasClientCertKey() const;

	const std::string& getCACertPath() const;
	void setCACertPath(const std::string& path);

	const std::string& getClientCertPath() const;
	void setClientCertPath(const std::string& path);

	const std::string& getClientCertKey() const;
	void setClientCertKey(const std::string& path);

private:
	static CertConfigurationPtr _config;

	CertConfiguration();

	std::string _caCertPath;
	std::string _clientCertPath;
	std::string _clientCertKeyPath;
};

} /* namespace network */
} /* namespace ignition */

#endif /* IGNITION_NETWORK_CRYPTO_CERTPATHCONFIGURATION_H_ */
