-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local _ffi = require('ffi')

local common = {
	httpNamespaceHeirarchy = { 'network', 'http' }
}

--[[
-- Creates a namespace heirarchy
--]]
function common.createNamespace(root, heirarchy)
	if heirarchy ~= nil then
		for _, name in pairs(heirarchy) do
			if type(root[name]) ~= 'table' then
				root[name] = {}
			end
			root = root[name] 
		end
		return root
	end	
	return false
end

--[[
-- Destroys a namespace
--]]
function common.destroyNamespace(root, heirarchy)
	if heirarchy ~= nil then
		root[heirarchy[1]] = nil
		return true
	end	
	return false
end

--[[
-- Fetch a metatable for a given FFI symbol
--]]
function common.getMetatableFor(metatableName)
	assert(type(metatableName) == 'string', 
		'metatableName must be of type string')
	
	local metatable = getMetatable(metatableName)
	if metatable == nil then
		error('Unable to retrieve metatable for ' .. metatableName)
	end
	
	return metatable
end

--[[
-- Return the FFI Symbol for a given name
--]]
function common.getFFIUserDataSymbol(symbolName)
	return _G[symbolName .. 'UserData']
end

--[[
-- Wraps a function which return const char* with a marshaller step to 
-- convert to a regular lua string
--]]
function common.augmentStringGetter(targetFnName, targetSymbol)
	local meta = common.getMetatableFor(targetSymbol)
	local intenalFn = meta[targetFnName]
	meta[targetFnName] = function (self, ...)
		return _ffi.string(intenalFn(self, ...))
	end
end

return common