/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_DATA_BUFFER_HTTP_RESPONSE_CONSUMER_H_
#define PLUGIN_NETWORK_HTTP_DATA_BUFFER_HTTP_RESPONSE_CONSUMER_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <DataStructures.h>
#include <utils/SharedBuffer.h>

#include <http/data/IHttpResponseConsumer.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace data
{

class BufferHttpResponseConsumer;
typedef core::memory::SharedPtr<BufferHttpResponseConsumer> BufferHttpResponseConsumerPtr;

class PLUGINNETWORK_API BufferHttpResponseConsumer :
	public IHttpResponseConsumer
{
	DECLARE_BINDABLE_ID(BufferHttpResponseConsumer);

public:
	static const crypto::HashedString& TYPE;

	BufferHttpResponseConsumer(core::SharedBufferPtr buffer);
	BufferHttpResponseConsumer(size_t seedBufferSize = 0);
	virtual ~BufferHttpResponseConsumer();

	virtual size_t getSize() const;
	virtual void setSizeHint(size_t size);

	virtual void consume(const void* contents, size_t size);
	virtual void consume(const IHttpResponseConsumer& consumer);
	void consume(const BufferHttpResponseConsumer& consumer);
	void consume(IStreamPtr stream, size_t size);

	virtual void initialise();
	virtual void finalise();

	virtual IStreamPtr getStream() const;

	virtual const crypto::HashedString& getType() const;

	const char* asPtr() const;
	const core::SharedBufferPtr asBuffer() const;
	core::SharedBufferPtr asBuffer();

	//! @brief Creates a string object from the vector buffer.
	//! Be aware, this action will more than likely result in a copy.
	//! Use this function sparingly!
	//! joshuaru@
	std::string asString() const;

	void clear();

private:
	void _reserveSizeToFit(size_t size);
	void _finalise() const;

	core::SharedBufferPtr _buffer;
};

} // namespace data
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_DATA_BUFFER_HTTP_RESPONSE_CONSUMER_H_
