/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_CACHE_I_HTTP_CACHE_PROVIDER_H_
#define PLUGIN_NETWORK_HTTP_CACHE_I_HTTP_CACHE_PROVIDER_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <http/HttpResponse.h>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{
class HttpRequest;

namespace cache
{

class IHttpCacheProvider;
typedef core::memory::SharedPtr<IHttpCacheProvider> IHttpCacheProviderPtr;

class PLUGINNETWORK_API IHttpCacheProvider :
	public javascript::sm::IBindable
{
	DECLARE_BINDABLE_ID(IHttpCacheProvider);

public:
	IHttpCacheProvider();
	virtual ~IHttpCacheProvider();

	virtual bool hasFor(
			const HttpRequest& request) = 0;

	virtual HttpResponseConstPtr getFor(
			const HttpRequest& request) = 0;

	virtual bool putFor(
			const HttpRequest& request, const HttpResponse& response) = 0;
};

} // namespace cache
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_CACHE_I_HTTP_CACHE_PROVIDER_H_
