/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_REQUEST_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_REQUEST_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <http/HttpRequest.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <bindings/lua/ffi/HttpHeadersSharedPtrLuaBinding.h>
#include <bindings/lua/ffi/HttpResponseSharedPtrLuaBinding.h>
#include <bindings/lua/ffi/IHttpClientSharedPtrLuaBinding.h>
#include <bindings/lua/ffi/IHttpCacheProviderSharedPtrLuaBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(HttpRequest, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct HttpRequestSharedPtrUserData HttpRequestSharedPtrUserData;

typedef struct HttpHeadersSharedPtrUserData HttpHeadersSharedPtrUserData;
typedef struct HttpResponseSharedPtrUserData HttpResponseSharedPtrUserData;
typedef struct IHttpClientSharedPtrUserData IHttpClientSharedPtrUserData;
typedef struct IHttpCacheProviderSharedPtrUserData IHttpCacheProviderSharedPtrUserData;

PLUGINNETWORK_API void network_HttpRequestSharedPtr_gc(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setRequestDispatchMode(
		HttpRequestSharedPtrUserData* self, uint32_t dispatchMode);

PLUGINNETWORK_API const char* network_HttpRequestSharedPtr_getUrl(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setUrl(
		HttpRequestSharedPtrUserData* self, const char* value);

PLUGINNETWORK_API int network_HttpRequestSharedPtr_getMethod(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setMethod(
		HttpRequestSharedPtrUserData* self, int value);

PLUGINNETWORK_API HttpHeadersSharedPtrUserData* network_HttpRequestSharedPtr_getHeaders(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setHeaders(
		HttpRequestSharedPtrUserData* self, HttpHeadersSharedPtrUserData* value);

PLUGINNETWORK_API uint32_t network_HttpRequestSharedPtr_getTimeout(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setTimeout(
		HttpRequestSharedPtrUserData* self, uint32_t value);

PLUGINNETWORK_API uint32_t network_HttpRequestSharedPtr_getConnectTimeout(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setConnectTimeout(
		HttpRequestSharedPtrUserData* self, uint32_t value);

PLUGINNETWORK_API const char* network_HttpRequestSharedPtr_getBody(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setBody(
		HttpRequestSharedPtrUserData* self, const char* value);

PLUGINNETWORK_API int network_HttpRequestSharedPtr_getState(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setResponse(
		HttpRequestSharedPtrUserData* self, HttpResponseSharedPtrUserData* value);

PLUGINNETWORK_API HttpResponseSharedPtrUserData* network_HttpRequestSharedPtr_getResponse(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setClient(
		HttpRequestSharedPtrUserData* self, IHttpClientSharedPtrUserData* value);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setCacheProvider(
		HttpRequestSharedPtrUserData* self, IHttpCacheProviderSharedPtrUserData* value);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_setProgressInterval(
		HttpRequestSharedPtrUserData* self, uint32_t value);

PLUGINNETWORK_API uint32_t network_HttpRequestSharedPtr_getProgressInterval(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_send(
		HttpRequestSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpRequestSharedPtr_abort(
		HttpRequestSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_REQUEST_SHARED_PTR_LUA_BINDING_H_
