/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_BINDINGS_LUA_LUA_HTTP_CACHE_POLICY_REGISTRY_BINDING_H_
#define PLUGIN_NETWORK_BINDINGS_LUA_LUA_HTTP_CACHE_POLICY_REGISTRY_BINDING_H_

#include <PluginLua.h>
#include <extensions/LuaExtension.h>
#include <NetworkConfig.h>
#include <http/HttpRequest.h>

namespace ignition
{
namespace network
{
namespace bindings
{
namespace lua
{

class PLUGINNETWORK_API LuaHttpCachePolicyRegistryBinding : 
		public ignition::lua::LuaExtension
{
	LUA_EXTENSION(LuaHttpCachePolicyRegistryBinding);

public:
	LuaHttpCachePolicyRegistryBinding(ignition::lua::LuaState* state);
	virtual ~LuaHttpCachePolicyRegistryBinding();

	ignition::lua::LuaState* getLuaState();
	ignition::lua::LuaFFILibWrapper* getLibWrapper();

private:
	void _addFfiBindings();
	void _removeFfiBindings();

	core::vector<std::string> _getFfiBindingNames();

	void _bindClass(const std::string& className);

	void _applyApiAugmentation();
	void _removeApiAugmentation();
	void _doExtensionScript(const std::string& script);

	ignition::lua::LuaFFILibWrapper _libWrapper;

	bool _isBound;
};

} // namespace lua
} // namespace bindings
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_BINDINGS_LUA_LUA_HTTP_CACHE_POLICY_REGISTRY_BINDING_H_
