/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_CLIENT_H_
#define PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_CLIENT_H_

#include <string>
#include "DataStructures.h"

// core
#include "event/UUIDObject.h"
#include "sm/SignallingBindable.h"
#include "core/thread/Mutex.h"

namespace ignition
{
namespace network
{

class WebSocketDelegate;

class WebSocketClient :
	public core::event::UUIDObject,
	public javascript::sm::SignallingBindable
{
DECLARE_BINDABLE_ID(WebSocketClient)
public:
	static WebSocketClient* fromId(core::UUID::ID_t id);

	WebSocketClient(WebSocketDelegate* delegate = nullptr);
	virtual ~WebSocketClient();

	bool connect(const std::string& uri);
	void disconnect(unsigned int status_code=0);

	bool send(const char* data, unsigned int length);
	bool send(const std::string& msg);
	const std::string& getUri();

	WebSocketDelegate* getDelegate();

protected:

	static core::unordered_map<
		core::UUID::ID_t, WebSocketClient*> _webSocketClientIdMap;
	static core::thread::Mutex _webSocketClientIdMapMutex;

	std::string _uri;
	WebSocketDelegate* _delegate;
};

} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_CLIENT_H_
