/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_HTTP_RESPONSE_H_
#define PLUGIN_NETWORK_HTTP_HTTP_RESPONSE_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <http/HttpHeaders.h>
#include <http/HttpResponseMetrics.h>
#include <http/data/IHttpResponseConsumer.h>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{

class HttpResponse;
typedef core::memory::SharedPtr<HttpResponse> HttpResponsePtr;
typedef core::memory::SharedPtr<const HttpResponse> HttpResponseConstPtr;

class PLUGINNETWORK_API HttpResponse :
	public javascript::sm::IBindable
{
	DECLARE_BINDABLE_ID(HttpResponse);

public:
	typedef uint16_t HttpStatus;

	HttpResponse();
	virtual ~HttpResponse();

	HttpResponse& operator=(const HttpResponse&);
	HttpResponse& operator=(HttpResponseConstPtr);

	void copyFrom(const HttpResponse&);
	void copyFrom(HttpResponseConstPtr);

	HttpHeaders& getHeaders();
	const HttpHeaders& getHeaders() const;
	void setHeaders(const HttpHeaders& headers);

	HttpStatus getStatus() const;
	void setStatus(HttpStatus status);

	data::IHttpResponseConsumerPtr getResponseConsumer() const;
	void setResponseConsumer(data::IHttpResponseConsumerPtr consumer);

	HttpResponseMetrics& getMetrics();
	const HttpResponseMetrics& getMetrics() const;
	void setMetrics(const HttpResponseMetrics& metrics);

private:
	HttpHeaders _headers;
	HttpStatus _status;
	data::IHttpResponseConsumerPtr _consumer;
	HttpResponseMetrics _metrics;
};

} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_HTTP_RESPONSE_H_
