/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_HTTP_HEADERS_H_
#define PLUGIN_NETWORK_HTTP_HTTP_HEADERS_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <DataStructures.h>
#include <algorithm/Comparators.h>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{

class HttpHeaders;
typedef core::memory::SharedPtr<HttpHeaders> HttpHeadersPtr;

class PLUGINNETWORK_API HttpHeaders :
	public javascript::sm::IBindable
{
public:
	DECLARE_BINDABLE_ID(HttpHeaders);

	typedef core::map<std::string, std::string,
			core::algorithm::CaseInsensitiveStringComparator> HttpHeadersMap;

	typedef HttpHeadersMap::value_type HttpHeader;

	HttpHeaders() = default;
	HttpHeaders(const HttpHeaders& headers);

	void setHeader(const std::string& name, const std::string& value);
	void setHeader(const HttpHeader& header);
	void setHeadersFrom(const HttpHeaders& headers);

	const std::string& getHeader(const std::string& name) const;
	bool unsetHeader(const std::string& name);

	bool hasHeader(const std::string& name) const;
	bool hasHeaderMatching(
			const std::string& name, const std::string& value) const;

	size_t size() const;
	const HttpHeadersMap& all() const;
	void clear();

	void replaceWith(const HttpHeaders& headers);
	HttpHeaders& operator=(const HttpHeaders& headers);

private:
	HttpHeadersMap _headers;
};

} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_HTTP_HEADERS_H_
