/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_BINDINGS_SM_HTTP_CACHE_PROVIDER_FACTORY_H_
#define PLUGIN_NETWORK_BINDINGS_SM_HTTP_CACHE_PROVIDER_FACTORY_H_

#include <NetworkConfig.h>
#include <http/cache/IHttpCacheProvider.h>
#include <sm/Extension.h>

namespace ignition
{
namespace network
{
namespace sm
{

class PLUGINNETWORK_API HttpCacheProviderFactoryExtension :
		public javascript::sm::Extension
{
public:
	HttpCacheProviderFactoryExtension(
			javascript::sm::SpiderMonkeyEnvironment* env);

	http::cache::IHttpCacheProviderPtr createDefault();
	http::cache::IHttpCacheProviderPtr createForPolicy(
			const std::string& policyName);
};

} // namespace sm
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_BINDINGS_SM_HTTP_CACHE_PROVIDER_FACTORY_H_

