/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADERS_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADERS_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <http/HttpHeaders.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <bindings/lua/ffi/HttpHeaderLuaBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(HttpHeaders, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct HttpHeaderUserData HttpHeaderUserData;
typedef struct HttpHeadersSharedPtrUserData HttpHeadersSharedPtrUserData;

PLUGINNETWORK_API HttpHeadersSharedPtrUserData* network_HttpHeadersSharedPtr_new();

PLUGINNETWORK_API void network_HttpHeadersSharedPtr_gc(
		HttpHeadersSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpHeadersSharedPtr_setHeader(
		HttpHeadersSharedPtrUserData* self, const char* name, const char* value);

PLUGINNETWORK_API void network_HttpHeadersSharedPtr_setHeadersFrom(
		HttpHeadersSharedPtrUserData* self, HttpHeadersSharedPtrUserData* from);

PLUGINNETWORK_API const char* network_HttpHeadersSharedPtr_getHeader(
		HttpHeadersSharedPtrUserData* self, const char* name);

PLUGINNETWORK_API bool network_HttpHeadersSharedPtr_unsetHeader(
		HttpHeadersSharedPtrUserData* self, const char* name);

PLUGINNETWORK_API bool network_HttpHeadersSharedPtr_hasHeader(
		HttpHeadersSharedPtrUserData* self, const char* name);

PLUGINNETWORK_API bool network_HttpHeadersSharedPtr_hasHeaderMatching(
		HttpHeadersSharedPtrUserData* self, const char* name, const char* value);

PLUGINNETWORK_API uint32_t network_HttpHeadersSharedPtr_size(
		HttpHeadersSharedPtrUserData* self);

PLUGINNETWORK_API uint32_t network_HttpHeadersSharedPtr_all(
		HttpHeadersSharedPtrUserData* self, HttpHeaderUserData* headers[], uint32_t size);

PLUGINNETWORK_API void network_HttpHeadersSharedPtr_clear(
		HttpHeadersSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpHeadersSharedPtr_replaceWith(
		HttpHeadersSharedPtrUserData* self, HttpHeadersSharedPtrUserData* source);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADERS_SHARED_PTR_LUA_BINDING_H_
