/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_BINDINGS_LUA_FFI_HTTP_CACHE_POLICY_REGISTRY_LUA_BINDING_H_
#define PLUGIN_NETWORK_BINDINGS_LUA_FFI_HTTP_CACHE_POLICY_REGISTRY_LUA_BINDING_H_

#include "http/cache/HttpCachePolicyRegistry.h"
#include "bindings/lua/ffi/NamespaceAliases.h"
#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaReflectableValueMapBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA(HttpCachePolicyRegistry, network);

namespace network
{
extern "C"
{

using core::ReflectableValueMapUserData;

/* @begin_ffi_externs */

typedef struct HttpCachePolicyRegistryUserData HttpCachePolicyRegistryUserData;

PLUGINNETWORK_API void network_http_cache_HttpCachePolicyRegistry_registerPolicy(
		const char* policyName, ReflectableValueMapUserData* policy);

PLUGINNETWORK_API void network_http_cache_HttpCachePolicyRegistry_deregisterPolicy(
		const char* policyName);

PLUGINNETWORK_API ReflectableValueMapUserData* network_http_cache_HttpCachePolicyRegistry_getPolicy(
		const char* policyName);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_BINDINGS_LUA_FFI_HTTP_CACHE_POLICY_REGISTRY_LUA_BINDING_H_
