/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_SERVICES_DATABASE_H_
#define PLUGIN_NETWORK_SERVICES_DATABASE_H_

#include "Servent.h"

#include <map>
#include <string>
#include <vector>

namespace ignition
{
namespace network
{

class ServicesDatabase
{
public:
	ServicesDatabase();
	servent* getEntryForName(std::string name);
	servent* getEntryForPort(int port, const char* proto);
private:
	void _populateMaps();
	std::vector<servent> _buildEntriesVector() const;

	const std::vector<servent> _entries;
	std::map<int, servent*> _portToEntryMap;
	std::map<std::string, servent*> _nameToEntryMap;
};

} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_SERVICES_DATABASE_H_