/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_FACTORY_HTTP_CACHE_PROVIDER_FACTORY_H_
#define PLUGIN_NETWORK_HTTP_FACTORY_HTTP_CACHE_PROVIDER_FACTORY_H_

#include <NetworkConfig.h>
#include <http/cache/IHttpCacheProvider.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace factory
{

class PLUGINNETWORK_API HttpCacheProviderFactory
{
public:
	static cache::IHttpCacheProviderPtr createDefault();
	static cache::IHttpCacheProviderPtr createForPolicy(
			const std::string& policyName);
};

} // namespace factory
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_FACTORY_HTTP_CACHE_PROVIDER_FACTORY_H_
