/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_DATA_FILE_HTTP_RESPONSE_CONSUMER_H_
#define PLUGIN_NETWORK_HTTP_DATA_FILE_HTTP_RESPONSE_CONSUMER_H_

#include <fstream>
#include <http/data/IHttpResponseConsumer.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace data
{

class FileHttpResponseConsumer;
typedef core::memory::SharedPtr<FileHttpResponseConsumer> FileHttpResponseConsumerPtr;

class PLUGINNETWORK_API FileHttpResponseConsumer :
	public IHttpResponseConsumer
{
	DECLARE_BINDABLE_ID(FileHttpResponseConsumer);

public:
	typedef core::memory::UniquePtr<std::fstream> FileStreamPtr;

	static const crypto::HashedString& TYPE;

	FileHttpResponseConsumer(
			const std::string& path,
			bool truncate = true);

	explicit FileHttpResponseConsumer(
			const std::string& path,
			FileStreamPtr stream);

	virtual ~FileHttpResponseConsumer();

	virtual size_t getSize() const;
	virtual void setSizeHint(size_t size);

	virtual void consume(const void* contents, size_t size);
	virtual void consume(const IHttpResponseConsumer& consumer);

	virtual void initialise();
	virtual void finalise();

	virtual IStreamPtr getStream() const;

	const std::string& getPath() const;

	virtual const crypto::HashedString& getType() const;

protected:
	void _init(const std::string& path, FileStreamPtr stream);
	void _assertGoodStream();

	size_t _consumedSize;
	std::string _path;
	FileStreamPtr _stream;
};

} // namespace data
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_DATA_FILE_HTTP_RESPONSE_CONSUMER_H_
