/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_HTTP_REQUEST_METRICS_H_
#define PLUGIN_NETWORK_HTTP_HTTP_REQUEST_METRICS_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <stdint.h>
#include <utils/TimerUtil.h>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{

class HttpResponseMetrics;
typedef core::memory::SharedPtr<HttpResponseMetrics> HttpResponseMetricsPtr;

class PLUGINNETWORK_API HttpResponseMetrics :
	public javascript::sm::IBindable
{
	DECLARE_BINDABLE_ID(HttpResponseMetrics);

public:
	HttpResponseMetrics();
	HttpResponseMetrics(const HttpResponseMetrics& metrics);

	void operator=(const HttpResponseMetrics& metrics);
	void copyFrom(const HttpResponseMetrics& metrics);

	//! @brief Time the request was started.
	core::MilliTime_t startTime;

	//! @brief Total request round tip time. From 'hitting' send to the last
	//! downloaded byte.
	core::MilliTime_t timeTotal;

	//! @brief Time to completion of the DNS lookup.
	core::MilliTime_t timeToNameLookup;

	//! @brief Time to establishment of the TCP connection to the server.
	core::MilliTime_t timeToConnect;

	//! @brief Time to the start of the first downloaded byte
	//! (including response header).
	core::MilliTime_t timeToDownloadStart;

	//! @brief Download speed in bytes-per-second.
	uint32_t downloadSpeed;

	//! @brief Upload speed in bytes-per-second.
	uint32_t uploadSpeed;

	//! @brief True if the response was yielded from cache.
	bool fetchedFromCache;

	//! @brief True if the response was put to cache.
	bool putToCache;
};

} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_HTTP_REQUEST_METRICS_H_
