/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_NETWORK_WEBSOCKET_EVENT_H_
#define IGNITION_NETWORK_WEBSOCKET_EVENT_H_

#include <event/EventService.h>
#include <event/EventHandler.h>
#include <event/events/Event.h>

namespace ignition
{
namespace network
{
using core::UUID;
using core::event::Event;
using core::event::EventName;
using core::event::EventHandler;
using core::event::Context;

class WebSocketEvent : public Event
{
	REGISTER_EVENT(WebSocketEvent);

public:
	static const EventName ON_OPEN;
	static const EventName ON_CLOSE;
	static const EventName ON_FAIL;
	static const EventName ON_MESSAGE;

	static WebSocketEvent* create(
			const EventName name,
			const UUID& sender,
			const std::string& message);

	static WebSocketEvent* clone(const WebSocketEvent& rhs);
	static WebSocketEvent& cast(Event& event);

	virtual ~WebSocketEvent();
	WebSocketEvent(const WebSocketEvent& other);
	WebSocketEvent& operator=(const WebSocketEvent& rhs);

	const std::string& getMessage() const;

	virtual void accept(EventHandler* const handler, Context& ctx);

	virtual std::string toString();

private:
	WebSocketEvent(const EventName, const UUID&, const std::string&);

	std::string _message;
};

} /* namespace input */
} /* namespace network */

#endif /* IGNITION_NETWORK_WEBSOCKET_EVENT_H_ */
