/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_NETWORK_BINDINGS_SM_WEBSOCKET_EXTENSION_H
#define IGNITION_NETWORK_BINDINGS_SM_WEBSOCKET_EXTENSION_H

#include "event/EventHandler.h"
#include "event/Subscriber.h"
#include "PluginNetworkBindingsIncludes.h"
#include "sm/Extension.h"
#include "websockets/WebSocketClient.h"

namespace ignition
{
namespace network
{
class WebSocketEvent;

namespace sm
{

class WebSocketExtension : 
	public javascript::sm::Extension, public core::event::EventHandler
{
public:
	WebSocketExtension(javascript::sm::SpiderMonkeyEnvironment* env);
	virtual ~WebSocketExtension();

	bool send(WebSocketClient* webSocketClient, JS::MutableHandleValue message);

	// core::event::EventHandler
	void handleEvent(core::event::Event& event, core::event::Context& ctx);
	void dispatchMessageToJS(WebSocketClient* webSocketClient, 
			WebSocketEvent* webSocketEvent);
private:
	void _createJsValueFromMessage(WebSocketClient* webSocketClient,
								   const std::string& message,
								   JS::MutableHandleValue jsValue);

	core::event::Subscriber _webSocketEventSubscriber;

};

} // namespace sm
} // namespace network
} // namespace ignition

#endif // IGNITION_NETWORK_BINDINGS_SM_WEBSOCKET_EXTENSION_H



