/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_NETWORK_BINDINGS_SM_NETWORK_EXTENSION_H
#define IGNITION_NETWORK_BINDINGS_SM_NETWORK_EXTENSION_H

#include "NetworkConfig.h"
#include "PluginNetworkBindingsIncludes.h"
#include "sm/Extension.h"

#include <DataStructures.h>
#include <http/HttpHeaders.h>
#include <http/HttpRequest.h>
#include <http/HttpResponse.h>
#include <http/client/IHttpClient.h>

namespace ignition
{
namespace network
{

namespace sm
{

class PLUGINNETWORK_API NetworkExtension : public javascript::sm::Extension
{
public:
	NetworkExtension(javascript::sm::SpiderMonkeyEnvironment* env);

	static std::string base64Encode(const std::string& str);
	static std::string base64Decode(const std::string& str);

	http::HttpHeadersPtr HttpRequest_getHeaders(
			http::HttpRequestPtr request);
	void HttpRequest_setHeaders(
			http::HttpRequestPtr request, http::HttpHeadersPtr headers);

	http::HttpHeadersPtr HttpResponse_getHeaders(
			http::HttpResponsePtr response);
	void HttpResponse_setHeaders(
			http::HttpResponsePtr response, http::HttpHeadersPtr headers);

	http::HttpResponseMetricsPtr HttpResponse_getMetrics(
			http::HttpResponsePtr response);
	void HttpResponse_setMetrics(
			http::HttpResponsePtr response, http::HttpResponseMetricsPtr metrics);

	void HttpHeaders_replaceWith(http::HttpHeadersPtr headers,
			http::HttpHeadersPtr from);

	void HttpHeaders_setHeadersFrom(http::HttpHeadersPtr headers,
				http::HttpHeadersPtr from);

	// [Custom]
	JSBool HttpHeaders_all(JSContext* cx, unsigned argc, JS::Value* vp);

	// [Custom]
	JSBool HttpRequest_setMethod(JSContext* cx, unsigned argc, JS::Value* vp);

	// [Custom]
	JSBool HttpRequest_send(JSContext* cx, unsigned argc, JS::Value* vp, bool sync = false);

	// [Custom]
	JSBool HttpRequest_sendSync(JSContext* cx, unsigned argc, JS::Value* vp);

protected:
	core::thread::Mutex _pendingRequestsMutex;
	core::map<http::HttpRequest*, http::HttpRequestPtr> _pendingRequests;

	void HttpRequest_stateChange(http::HttpRequestWeakPtr requestWeak,
			http::HttpState::Type state);
	void HttpRequest_progress(http::HttpRequestWeakPtr requestWeak,
			size_t downTotal, size_t downCurrent,
			size_t upTotal, size_t upCurrent);
	void HttpRequest_complete(http::HttpRequestWeakPtr requestWeak);

	void _attachHttpRequestSignalHandlers(http::HttpRequestPtr request);
};

} // namespace sm
} // namespace network
} // namespace ignition

#endif // IGNITION_NETWORK_BINDINGS_SM_NETWORK_EXTENSION_H



