/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef IGNITION_NETWORK_BINDINGS_SM_HTTP_CACHE_POLICY_REGISTRY_EXTENSION_H
#define IGNITION_NETWORK_BINDINGS_SM_HTTP_CACHE_POLICY_REGISTRY_EXTENSION_H

#include "NetworkConfig.h"
#include "PluginNetworkBindingsIncludes.h"
#include "http/cache/HttpCachePolicyRegistry.h"
#include "sm/Extension.h"

namespace ignition
{
namespace network
{
namespace sm
{

class PLUGINNETWORK_API HttpCachePolicyRegistryExtension : public javascript::sm::Extension
{
public:
	HttpCachePolicyRegistryExtension(javascript::sm::SpiderMonkeyEnvironment* env);

	void registerPolicy(
			const std::string& policyName, JS::MutableHandleObject policy);
	void deregisterPolicy(const std::string& policyName);

protected:
	http::cache::HttpCachePolicy _jsObjectToHttpCachePolicy(
			JS::MutableHandleObject obj);

	int _getInt(JS::MutableHandleObject obj, const std::string& member);
	std::string _getString(JS::MutableHandleObject obj, const std::string& member);
	JS::Value _getMember(JS::MutableHandleObject obj, const std::string& member);
	void _throwError(const std::string& errorMsg);
};

} // namespace sm
} // namespace network
} // namespace ignition

#endif // IGNITION_NETWORK_BINDINGS_SM_HTTP_CACHE_POLICY_REGISTRY_EXTENSION_H



