/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_RESPONSE_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_RESPONSE_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <http/HttpResponse.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <bindings/lua/ffi/HttpHeadersSharedPtrLuaBinding.h>
#include <bindings/lua/ffi/IHttpResponseConsumerSharedPtrLuaBinding.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(HttpResponse, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct HttpResponseSharedPtrUserData HttpResponseSharedPtrUserData;
typedef struct HttpHeadersSharedPtrUserData HttpHeadersSharedPtrUserData;
typedef struct IHttpResponseConsumerSharedPtrUserData IHttpResponseConsumerSharedPtrUserData;

PLUGINNETWORK_API HttpResponseSharedPtrUserData* network_HttpResponseSharedPtr_new();

PLUGINNETWORK_API void network_HttpResponseSharedPtr_gc(
		HttpResponseSharedPtrUserData* self);

PLUGINNETWORK_API HttpHeadersSharedPtrUserData* network_HttpResponseSharedPtr_getHeaders(
		HttpResponseSharedPtrUserData* self);

PLUGINNETWORK_API int network_HttpResponseSharedPtr_getStatus(
		HttpResponseSharedPtrUserData* self);

PLUGINNETWORK_API IHttpResponseConsumerSharedPtrUserData*
network_HttpResponseSharedPtr_getResponseConsumer(
		HttpResponseSharedPtrUserData* self);

PLUGINNETWORK_API void network_HttpResponseSharedPtr_setResponseConsumer(
		HttpResponseSharedPtrUserData* self,
		IHttpResponseConsumerSharedPtrUserData* value);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_RESPONSE_SHARED_PTR_LUA_BINDING_H_
