/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_FACTORY_HTTP_RESPONSE_CONSUMER_FACTORY_H_
#define PLUGIN_NETWORK_HTTP_FACTORY_HTTP_RESPONSE_CONSUMER_FACTORY_H_

#include <NetworkConfig.h>
#include <http/data/IHttpResponseConsumer.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace factory
{

class PLUGINNETWORK_API HttpResponseConsumerFactory
{
public:
	static data::IHttpResponseConsumerPtr createBufferConsumer();
	static data::IHttpResponseConsumerPtr createFileConsumer(
			const std::string& path);
};

} // namespace factory
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_FACTORY_HTTP_RESPONSE_CONSUMER_FACTORY_H_
