/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_CACHED_HTTP_REQUEST_H_
#define PLUGIN_NETWORK_HTTP_CACHED_HTTP_REQUEST_H_

#include "NetworkConfig.h"
#include "http/cache/IHttpCacheProvider.h"
#include "http/cache/HttpCachePolicyRegistry.h"
#include "http/HttpRequest.h"
#include "http/HttpResponse.h"
#include <CachingService.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace cache
{

class PLUGINNETWORK_API CacheServiceHttpCacheProvider :
		public cache::IHttpCacheProvider
{

public:
	CacheServiceHttpCacheProvider(const std::string& httpCachePolicy);

	virtual ~CacheServiceHttpCacheProvider();

	virtual bool hasFor(
			const HttpRequest& request);

	virtual HttpResponseConstPtr getFor(
			const HttpRequest& request);

	virtual bool putFor(
			const HttpRequest& request, const HttpResponse& response);

	std::string buildKeyFor(const HttpRequest& request) const;

protected:
	ignition::cache::ICachePtr _getCacheBucket(const std::string& cacheName);
	bool _shouldCache(const HttpRequest& request, const HttpResponse& response);
	void _addToCache(const HttpRequest& request, const HttpResponse& response);
	uint32_t _getTtlForResponse(const HttpResponse& response);

	uint32_t _getDefaultResponseTtl() const;

	HttpCachePolicy::TTLMode _ttlMode;
	uint32_t _ttl;
	ignition::cache::ICachePtr _cache;
};

} // namespace cache
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_CACHED_HTTP_REQUEST_H_
