/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_HTTP_METHOD_H_
#define PLUGIN_NETWORK_HTTP_HTTP_METHOD_H_

#include "NetworkConfig.h"
#include <algorithm/Comparators.h>

namespace ignition
{
namespace network
{
namespace http
{

struct PLUGINNETWORK_API HttpMethod
{
	// BE AWARE.
	// By altering these enum values you may be affecting the behaviour of
	// the Lua and JS bindings. Make sure changes made here are reflected
	// where applicable.
	enum Type
	{
		UNKNOWN = 0,

		// HTTP Method Verbs as described by:
		// - http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html
		// - Section: 9 Method Definitions
		GET = 1,
		HEAD = 2,
		POST = 3,
		PUT = 4,
		DELETE = 5,
		TRACE = 6,
		OPTIONS = 7
	};

	static Type fromString(const std::string& str);
	static const std::string& toString(Type type);
};

} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_HTTP_METHOD_H_
