/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_NAMESPACE_ALIASES_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_NAMESPACE_ALIASES_H_

#include <http/HttpHeaders.h>

namespace ignition
{

namespace network
{

// Why does this exist?
// The headers aliases some nested HTTP Request namespaces into ignition::network.
// This is done to circumvent the way the FFI Function Exporter for the PS3 works
// And also the way the CREATE_FFI_USER_DATA* family of macros generates code.
// The CREATE_FFI_USER_DATA* macros expect all bound types to exist under 
// ignition::foo, where foo in this case would be network.
// We can get around this by aliasing the type in the header which is defining the
// the FFI interface, however, the PS3 function export script picks up on this extra
// namespace and you end up with something like ::ignition::network::network.

namespace http
{
namespace data {}
namespace cache {}
namespace client {}
} // namespace http

using namespace http;
using namespace http::data;
using namespace http::cache;
using namespace http::client;

typedef HttpHeaders::HttpHeader HttpHeader;

} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_NAMESPACE_ALIASES_H_
