/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_RESPONSE_CONSUMER_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_RESPONSE_CONSUMER_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <http/data/IHttpResponseConsumer.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(IHttpResponseConsumer, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct IHttpResponseConsumerSharedPtrUserData
IHttpResponseConsumerSharedPtrUserData;

PLUGINNETWORK_API void network_IHttpResponseConsumerSharedPtr_gc(
		IHttpResponseConsumerSharedPtrUserData* self);

PLUGINNETWORK_API uint32_t network_IHttpResponseConsumerSharedPtr_getSize(
		IHttpResponseConsumerSharedPtrUserData* self);

PLUGINNETWORK_API const char* network_IHttpResponseConsumerSharedPtr_getType(
		IHttpResponseConsumerSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_RESPONSE_CONSUMER_SHARED_PTR_LUA_BINDING_H_
