/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_LUA_HTTP_REQUEST_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_LUA_HTTP_REQUEST_BINDING_H_

#include <extensions/LuaExtension.h>
#include <ffi/LuaFFILibWrapper.h>
#include <utils/LuaRegistryRef.h>
#include <NetworkConfig.h>
#include <DataStructures.h>

namespace ignition
{

namespace lua
{
class IMetatabledClassInstance;
}

namespace network
{
namespace bindings
{
namespace lua
{

class PLUGINNETWORK_API LuaHttpRequestBinding : public ignition::lua::LuaExtension
{
	LUA_EXTENSION(LuaHttpRequestBinding);

public:
	static const std::string API_NAMESPACE;

	LuaHttpRequestBinding(ignition::lua::LuaState* state);
	~LuaHttpRequestBinding();

	ignition::lua::LuaState* getLuaState();
	ignition::lua::LuaFFILibWrapper* getLibWrapper();

protected:
	struct FfiBindingDescriptor
	{
		std::string name;
		std::string extends;
	};

	static core::vector<FfiBindingDescriptor> _getFfiBindingDescriptors();

	void _addFfiBindings();
	void _removeFfiBindings();

	void _bindClass(const std::string& className, const std::string& extends);

	void _applyApiAugmentation();
	void _removeApiAugmentation();
	void _doExtensionScript(const std::string& script);

	ignition::lua::LuaFFILibWrapper _libWrapper;

	bool _isBound;
};

} // namespace lua
} // namespace bindings
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_LUA_HTTP_REQUEST_BINDING_H_
