-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--[[
-- Applies HttpCachePolicyRegistry Binding Extension Augmentations
--]]
return function ()
	local _ffi = require('ffi')

	_G.network = _G.network or {}
	_G.network.http = _G.network.http or {}
	_G.network.http.cache = _G.network.http.cache or {}
	_G.network.http.cache.ttlMode =
	{
		HONOUR_EXPIRES_HEADER_IF_SOONER = 0,
		HONOUR_EXPIRES_HEADER_IF_LATER = 1
	}
	
	-- Alias the HttpCachePolicyRegistry metatable as a member of the global
	-- table for the convenience.
	_G.network.http.cache.HttpCachePolicyRegistry = getMetatable('HttpCachePolicyRegistryUserData')
end