/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_DELEGATE_H_
#define PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_DELEGATE_H_

#include <string>
#include <utils/UUID.h>

#if !defined(PLUGINNETWORK_BUILD_LIBWEBSOCKET)
// websocketpp
#define BOOST_ASIO_HAS_STD_CHRONO
#include <websocketpp/config/boost_config.hpp>
#include <websocketpp/config/asio_no_tls_client.hpp>
#include <websocketpp/client.hpp>

typedef websocketpp::client<websocketpp::config::asio_client> client;

#elif defined(PLUGINNETWORK_BUILD_LIBWEBSOCKET)
#include <libwebsockets.h>
#include <boost/regex.hpp>
#include <DataStructures.h>
#endif

namespace boost
{
class thread;
}

namespace ignition
{
namespace network
{

class WebSocketDelegate
{

public:

	WebSocketDelegate(core::UUID uuid);
	virtual ~WebSocketDelegate();

	bool connect(const std::string& uri);
	void disconnect(unsigned int statusCode);
	bool send(const char* data, unsigned int length);
	const std::string& getUri();

protected:

#if !defined(PLUGINNETWORK_BUILD_LIBWEBSOCKET) 
	virtual void onOpen(websocketpp::connection_hdl hdl);
	virtual void onClose(websocketpp::connection_hdl hdl);
	virtual void onFail(websocketpp::connection_hdl hdl);
	virtual void onMessage(websocketpp::connection_hdl hdl, client::message_ptr msg);

	client _client;
	client::connection_ptr _connection;
#elif defined(PLUGINNETWORK_BUILD_LIBWEBSOCKET)
	struct libwebsocket* _websocket;
	struct libwebsocket_context* _context;
	struct libwebsocket_protocols _protocols[2];

	static int callback_entrance(struct libwebsocket_context* context, struct libwebsocket* wsi, enum libwebsocket_callback_reasons reason, void* user, void* in, size_t len);

public:
	int callback_main(struct libwebsocket_context* context, struct libwebsocket* wsi, enum libwebsocket_callback_reasons reason, void* user, void* in, size_t len);
protected:
	void Run();

	virtual void onOpen(struct libwebsocket_context* context);
	virtual void onClose(struct libwebsocket_context* context);
	virtual void onFail(struct libwebsocket_context* context, void* msg, size_t len);
	virtual void onMessage(struct libwebsocket_context* context, void* msg, size_t len);
#endif

	std::string _uri;
	core::UUID _uuid;

	boost::thread* _clientThread;

	static unsigned int _instanceCounter;

private:
#if defined(PLUGINNETWORK_BUILD_LIBWEBSOCKET)
	static const boost::regex URI_REGEX;
	static const int BASE_TEN;
	static const int MAX_PORT_NUMBER;

	bool _isInConnect;
	static const int SOCKET_WAIT_TIMEOUT = 100;
	static const int MAX_QUEUE_SIZE = 30;

	static bool _validateURI(const std::string& uri, std::string& address, int& port, std::string& path);

	core::queue<std::string> _messageQueue;
	void _sendNextMessage();
#endif
};

} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_WEBSOCKETS_WEBSOCKET_CLIENT_H_
