/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_DATA_I_HTTP_RESPONSE_CONSUMER_H_
#define PLUGIN_NETWORK_HTTP_DATA_I_HTTP_RESPONSE_CONSUMER_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <crypto/HashedString.h>
#include <istream>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{
namespace data
{

class IHttpResponseConsumer;
typedef core::memory::SharedPtr<IHttpResponseConsumer> IHttpResponseConsumerPtr;

class PLUGINNETWORK_API IHttpResponseConsumer :
	public javascript::sm::IBindable
{
	DECLARE_BINDABLE_ID(IHttpResponseConsumer);

public:
	typedef core::memory::UniquePtr<std::istream> IStreamPtr;

	IHttpResponseConsumer();
	virtual ~IHttpResponseConsumer();

	virtual size_t getSize() const = 0;
	virtual void setSizeHint(size_t size) = 0;

	virtual void consume(const void* contents, size_t size) = 0;
	virtual void consume(const IHttpResponseConsumer& consumer) = 0;

	virtual void initialise() = 0;
	virtual void finalise() = 0;

	virtual IStreamPtr getStream() const = 0;

	virtual const crypto::HashedString& getType() const = 0;
};

} // namespace data
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_DATA_I_HTTP_RESPONSE_CONSUMER_H_
