/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_CLIENT_I_HTTP_CLIENT_H_
#define PLUGIN_NETWORK_HTTP_CLIENT_I_HTTP_CLIENT_H_

#include <NetworkConfig.h>
#include <SmartPointers.h>
#include <Function.h>
#include <http/HttpResponse.h>
#include <http/HttpState.h>
#include <sm/IBindable.h>

namespace ignition
{
namespace network
{
namespace http
{
class HttpRequest;

namespace client
{

class IHttpClient;
typedef core::memory::SharedPtr<IHttpClient> IHttpClientPtr;

class PLUGINNETWORK_API IHttpClient :
	public javascript::sm::IBindable
{
	DECLARE_BINDABLE_ID(IHttpClient);

public:
	typedef core::function<void(
			HttpState::Type state)> StateChangeCallback;

	typedef core::function<void(
			size_t downTotal,
			size_t downCurrent,
			size_t upTotal,
			size_t upCurrent)> DataProgressCallback;

	IHttpClient();
	virtual ~IHttpClient();

	virtual void makeRequest(
			const HttpRequest& request,
			HttpResponsePtr response) = 0;

	virtual void abort() = 0;

	virtual void setStateChangeCallback(StateChangeCallback callback) = 0;
	virtual void setDataProgressCallback(DataProgressCallback callback) = 0;
	virtual void setDataProgressInterval(core::MilliTime_t interval) = 0;
};

} // namespace client
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_CLIENT_I_HTTP_CLIENT_H_
