/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_HTTP_CACHE_HTTP_CACHE_POLICY_REGISTRY_H_
#define PLUGIN_NETWORK_HTTP_CACHE_HTTP_CACHE_POLICY_REGISTRY_H_

#include "NetworkConfig.h"
#include <core/thread/Mutex.h>
#include <DataStructures.h>
#include <string>

namespace ignition
{
namespace network
{
namespace http
{
namespace cache
{

struct HttpCachePolicy
{
	// This enum specifies how to decide which TTL should be used. Either:
	//     - the value returned in the HTTP 'expires' header;
	//     - or the value provided in the 'ttl' field of this struct
	//
	// Important: remember to update the values in 'PluginNetworkHttpRequest.idl'
	//            and 'LuaHttpCachePolicyRegistryBinding_apply' if these values
	//            change
	enum TTLMode
	{
		TTL_MODE_HONOUR_EXPIRES_HEADER_IF_SOONER = 0,
		TTL_MODE_HONOUR_EXPIRES_HEADER_IF_LATER = 1
	};

	HttpCachePolicy();

	TTLMode ttlMode;
	uint32_t ttl;
	std::string cacheBucket;
	std::string keyGenerationRule;
};

class PLUGINNETWORK_API HttpCachePolicyRegistry
{
public:
	static HttpCachePolicyRegistry& get();

	~HttpCachePolicyRegistry();

	void registerPolicy(
			const std::string& policyName, const HttpCachePolicy& policy);
	void deregisterPolicy(const std::string& policyName);
	HttpCachePolicy getPolicy(const std::string&);
	void clear();

protected:
	HttpCachePolicyRegistry();

	core::map<std::string, HttpCachePolicy> _policyMap;
	core::thread::Mutex _policyMutex;
};

} // namespace cache
} // namespace http
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_HTTP_CACHE_HTTP_CACHE_POLICY_REGISTRY_H_
