/* Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_NETWORK_BINDINGS_SM_HTTP_RESPONSE_CONSUMER_FACTORY_H_
#define PLUGIN_NETWORK_BINDINGS_SM_HTTP_RESPONSE_CONSUMER_FACTORY_H_

#include <NetworkConfig.h>
#include <http/data/IHttpResponseConsumer.h>
#include <sm/Extension.h>

namespace ignition
{
namespace network
{
namespace sm
{

class PLUGINNETWORK_API HttpResponseConsumerFactoryExtension :
	public javascript::sm::Extension
{
public:
	HttpResponseConsumerFactoryExtension(
			javascript::sm::SpiderMonkeyEnvironment* env);

	http::data::IHttpResponseConsumerPtr createBufferConsumer();
	http::data::IHttpResponseConsumerPtr createFileConsumer(
			const std::string& path);
};

} // namespace sm
} // namespace network
} // namespace ignition

#endif // PLUGIN_NETWORK_BINDINGS_SM_HTTP_RESPONSE_CONSUMER_FACTORY_H_
