/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_CACHE_PROVIDER_SHARED_PTR_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_CACHE_PROVIDER_SHARED_PTR_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <http/cache/IHttpCacheProvider.h>

namespace ignition
{

CREATE_FFI_USER_DATA_SHARED_PTR(IHttpCacheProvider, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct IHttpCacheProviderSharedPtrUserData IHttpCacheProviderSharedPtrUserData;

PLUGINNETWORK_API void network_IHttpCacheProviderSharedPtr_gc(
		IHttpCacheProviderSharedPtrUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_I_HTTP_CACHE_PROVIDER_SHARED_PTR_LUA_BINDING_H_
