/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADER_LUA_BINDING_H_
#define PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADER_LUA_BINDING_H_

#include <ffi/LuaFFIUserData.h>
#include <NetworkConfig.h>
#include <bindings/lua/ffi/NamespaceAliases.h>
#include <http/HttpHeaders.h>

namespace ignition
{

CREATE_FFI_USER_DATA(HttpHeader, network);

namespace network
{
extern "C"
{

/* @begin_ffi_externs */

typedef struct HttpHeaderUserData HttpHeaderUserData;

PLUGINNETWORK_API HttpHeaderUserData* network_HttpHeader_new();

PLUGINNETWORK_API void network_HttpHeader_gc(
		HttpHeaderUserData* self);

PLUGINNETWORK_API const char* network_HttpHeader_getFirst(
		HttpHeaderUserData* self);

PLUGINNETWORK_API const char* network_HttpHeader_getSecond(
		HttpHeaderUserData* self);

/* @end_ffi_externs */

} // extern "C"
} // namespace network
} // namespace ignition

#endif // PLUGIN_VIEWS_BINDINGS_LUA_FFI_HTTP_HEADER_LUA_BINDING_H_
