-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local IPreprocessor = require("preprocessors.IPreprocessor")

local MovingAveragePreprocessor = class(IPreprocessor, function(self, bufferSize)
	self._bufferSize = bufferSize
	self._buffer = {}
end)


function MovingAveragePreprocessor:preprocess(data)
	self:_addSample(data)

	if self:_isBufferFull() then
		return self:_getAverage()
	end

	return nil
end

function MovingAveragePreprocessor:_addSample(data)
	if self:_isBufferFull() then
		table.remove(self._buffer, 1)
	end

	table.insert(self._buffer, data)
end

function MovingAveragePreprocessor:_isBufferFull()
	return (#self._buffer == self._bufferSize)
end

function MovingAveragePreprocessor:_getAverage()
	local sum = 0
	for i, t in ipairs(self._buffer) do
		sum = sum + t
	end

	return sum / #self._buffer
end

return MovingAveragePreprocessor