-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local function SimplePrinter(printFunction)

	local function addLine(buffer, line)
		return buffer .. '%% ' .. line .. '\n'
	end

	local function printer(timeData)
		local toPrint = '\n'

		toPrint = addLine(toPrint, 'METRIC MEASURED: ' .. timeData.metricName)
		local startTime = timeData.markers[1].time
		local totalTime

		toPrint = addLine(toPrint, "Metadata:")
		for key, value in pairs(timeData.metadata) do
			toPrint = addLine("\t" .. key .. ": " .. value)
		end

		for i = 1, #timeData.markers do
			local marker = timeData.markers[i]

			local relativeTime = marker.time - startTime

			local line ='Marker ' .. marker.markerName .. '-' ..
					marker.markerType .. ' @ ' .. marker.time .. 'ms (t0 + ' ..
					relativeTime .. 'ms)'
			toPrint = addLine(toPrint, line)

			if i == #timeData.markers then
				totalTime = relativeTime
			end
		end

		toPrint = addLine(toPrint, 'Total time: ' .. totalTime .. 'ms')
		printFunction(toPrint)
	end

	return printer
end

return SimplePrinter