-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local NoopPreprocessor = require('preprocessors.NoopPreprocessor')

local function MetricAccumulator(metricManager, preprocessor)
	if not preprocessor then
		preprocessor = NoopPreprocessor.new()
	end

	return function(timeData)
		local data = preprocessor:preprocess(timeData.totalTime)

		if data then
			metricManager:storeMetricSample(timeData.metricName, data)
		end
	end
end

return MetricAccumulator
