-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local function CallbackComposer(callbacks, preprocessor)
	return function(timeData)
		if preprocessor then
			timeData.totalTime = preprocessor:preprocess(timeData.totalTime)
		end

		for i, callback in ipairs(callbacks) do
			callback(timeData)
		end
	end
end

return CallbackComposer